/* Adobe.MidiFun.js -- MidiFun behavior for Animal */
/*global define */

define(["lib/Zoot", "lib/tasks"],
function (Z, tasks) {
	"use strict";

	var	kVisuals_Lines = 0;
	
	function createBall (builder, fillColor, strokeColor, strokeWidth, radius, position) {
		var p, graphics;

		p = new Z.Path();
		graphics = builder.newGraphics();
		graphics.position = position.slice(0);
		graphics.radius = radius;
		p.addEllipse([-graphics.radius, -graphics.radius, graphics.radius * 2, graphics.radius * 2]);
		graphics.fillPath(fillColor, p);
		if (strokeWidth) {
			graphics.strokePath(strokeColor, p, 1.5);
		}
		graphics.setName("ball");
		return graphics;
	}	
	
	return {
		about: "$$$/private/animal/Behavior/MidiFun/About=MIDI Fun",
		description: "$$$/private/animal/Behavior/MidiFun/Desc=Have Fun with MIDI Visualization",
		uiName: "$$$/private/animal/Behavior/MidiFun/UIName=Midi Fun",
		defaultArmedForRecordOn: true,
		hideInBehaviorList: true,
	
		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{ id: "visuals", type: "enum", uiName: "$$$/private/animal/Behavior/MidiFun/Parameter/BlendMode=Options",
					items: [{ id: kVisuals_Lines, uiName: "$$$/private/animal/Behavior/MidiFun/Parameter/BlendMode/Option1=Option 1" }
						   ], dephault: kVisuals_Lines
				},
				{ id: "midiInput", type: "eventGraph", uiName: "$$$/private/animal/Behavior/MidiFun/Parameter/midiInput=MIDI Input",
					inputKeysArray: ["Midi/"], uiToolTip: "$$$/private/animal/Behavior/MidiFun/Parameter/midiInput/tooltip=MIDI input", defaultArmedForRecordOn: true
				},
				{id:"midiChannel", type:"slider", uiName:"$$$/private/animal/Behavior/MidiFun/Param/MidiChannel=Midi Channel",	precision:0, dephault:1,
																		min:1, max:16},
				{id:"midiNoteMin", type:"slider", uiName:"$$$/private/animal/Behavior/MidiFun/Param/midiNoteMin=Midi Note Minimum",	precision:0, dephault:0,
																		min:0, max:127},
				{id:"midiNoteMax", type:"slider", uiName:"$$$/private/animal/Behavior/MidiFun/Param/midiNoteMax=Midi Note Maximum",	precision:0, dephault:127,
																		min:0, max:127},
				{id:"noteRadius", type:"slider", uiName:"$$$/private/animal/Behavior/MidiFun/Param/midiNoteRadius=Note Radius", precision:0, dephault:5,
																		min:0, max:100},
				{id:"noteDistance", type:"slider", uiName:"$$$/private/animal/Behavior/MidiFun/Param/midiNoteSpread=Note Distance", precision:0, dephault:10,
																		min:0, max:100},
			];
		},

		onCreateBackStageBehavior: function (self) {
			return { order: 0.01, importance : 0.0 };
		},

		onCreateStageBehavior: function (self, args) {
			self.builder = Z.nml.newBuilder();
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage		
			var visuals = args.getParam("visuals"), container = args.stagePuppet.getDisplayContainer(), art, b,
				fillColor = new Z.Color(1, 1, 1, 0.5), strokeColor = new Z.Color(1, 0, 0, 0.5), strokeWidth = 1.0, radius = 10,
				position = [0, 0], i, midiChannel = args.getParam("midiChannel"),
				noteMin = args.getParam("midiNoteMin"), noteMax = args.getParam("midiNoteMax"), noteGraphic,
				noteDistance = args.getParam("noteDistance"), noteRadius = args.getParam("noteRadius"), mtx, s, v, noteKey, cc;

			cc = args.getParamEventValue("midiInput", "Midi/1/CCRPN/15/Value");
			if (cc === undefined) {
				cc = 1;
			} else {
				cc /= 8192.0;
			}
			
			container.removeChildren();
			
			art = self.builder.newContainer("MidiFunArt");
	
			b = createBall(self.builder, fillColor, strokeColor, strokeWidth, noteRadius, position);
			
			for (i = noteMin; i < noteMax; i = i + 1) 
			{
				noteGraphic = b.clone();
				noteGraphic.setBlendMode("Screen");
				
				mtx = noteGraphic.getMatrix();
				noteKey = "Midi/" + midiChannel + "/Note/" + i;
				s = args.getParamEventValue("midiInput", noteKey + "/Down") || 0; 
				if (s) {
					v = args.getParamEventValue("midiInput", noteKey + "/Velocity") || 0;
					if (v) {
						s *= v * noteRadius * cc;
					}
				}
				if (s < 0.5) s = 0.5;
				
				mtx = mtx.prescale([s, s]);

				mtx = mtx.pretranslate(Z.Vec2([i * noteDistance - (noteDistance * (noteMax-noteMin)) * 0.5, 0.0]));
				noteGraphic.setMatrix(mtx);
				
				art.addChild(noteGraphic);
			}

			container.addChild(art);
			
			switch (visuals) {
				case kVisuals_Lines: {
					
				}
				break;
			}
			
			args.setEventGraphParamRecordingValid("midiInput");

		}

	}; // end of object being returned
});
